package org.sp.model;

import java.math.BigDecimal;
import java.math.BigInteger;

import javax.xml.datatype.XMLGregorianCalendar;

/**
 * TrackPoint is a subset of the official GPX 1.1 specification for WptType complexType.
 * We only care about the attributes related to cycling.
 * 
 * @author Peter Lin
 *
 */
public class TrackPoint {
    protected BigDecimal elevation;
    protected XMLGregorianCalendar time;
    protected BigDecimal magneticVariation;
    /// Height (in meters) of geoid (mean sea level) above WGS84 earth ellipsoid. As defined in NMEA GGA message.
    protected BigDecimal geoidHeight;
    /// Source of data. Included to give user some idea of reliability and accuracy of data. "Garmin eTrex", "USGS quad Boston North", e.g.
    protected String source;
    /// Type of GPS fix
    protected String fix;
    /// Number of Satellites used to calculate GPS lat/long
    protected BigInteger numberOfSatellites;
    protected BigDecimal horizontalDilutionOfPrecision;
    protected BigDecimal verticalDilutionOfPrecision;
    protected BigDecimal positionDilutionOfPrecision;
    protected BigDecimal ageOfdGPSData;
    /// ID of DGPS station used in differential correction
    protected Integer dGPSId;
    protected Extension extensions;
    protected BigDecimal latitude;
    protected BigDecimal longitude;

    public TrackPoint() {
    	super();
    }

	public BigDecimal getElevation() {
		return elevation;
	}

	public void setElevation(BigDecimal elevation) {
		this.elevation = elevation;
	}

	public XMLGregorianCalendar getTime() {
		return time;
	}

	public void setTime(XMLGregorianCalendar time) {
		this.time = time;
	}

	public BigDecimal getMagneticVariation() {
		return magneticVariation;
	}

	public void setMagneticVariation(BigDecimal magneticVariation) {
		this.magneticVariation = magneticVariation;
	}

	public BigDecimal getGeoidHeight() {
		return geoidHeight;
	}

	public void setGeoidHeight(BigDecimal geoidHeight) {
		this.geoidHeight = geoidHeight;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getFix() {
		return fix;
	}

	public void setFix(String fix) {
		this.fix = fix;
	}

	public BigInteger getNumberOfSatellites() {
		return numberOfSatellites;
	}

	public void setNumberOfSatellites(BigInteger numberOfSatellites) {
		this.numberOfSatellites = numberOfSatellites;
	}

	public BigDecimal getHorizontalDilutionOfPrecision() {
		return horizontalDilutionOfPrecision;
	}

	public void setHorizontalDilutionOfPrecision(
			BigDecimal horizontalDilutionOfPrecision) {
		this.horizontalDilutionOfPrecision = horizontalDilutionOfPrecision;
	}

	public BigDecimal getVerticalDilutionOfPrecision() {
		return verticalDilutionOfPrecision;
	}

	public void setVerticalDilutionOfPrecision(
			BigDecimal verticalDilutionOfPrecision) {
		this.verticalDilutionOfPrecision = verticalDilutionOfPrecision;
	}

	public BigDecimal getPositionDilutionOfPrecision() {
		return positionDilutionOfPrecision;
	}

	public void setPositionDilutionOfPrecision(
			BigDecimal positionDilutionOfPrecision) {
		this.positionDilutionOfPrecision = positionDilutionOfPrecision;
	}

	public BigDecimal getAgeOfdGPSData() {
		return ageOfdGPSData;
	}

	public void setAgeOfdGPSData(BigDecimal ageOfdGPSData) {
		this.ageOfdGPSData = ageOfdGPSData;
	}

	public Integer getdGPSId() {
		return dGPSId;
	}

	public void setdGPSId(Integer dGPSId) {
		this.dGPSId = dGPSId;
	}

	public Extension getExtensions() {
		return extensions;
	}

	public void setExtensions(Extension extensions) {
		this.extensions = extensions;
	}

	public BigDecimal getLatitude() {
		return latitude;
	}

	public void setLatitude(BigDecimal latitude) {
		this.latitude = latitude;
	}

	public BigDecimal getLongitude() {
		return longitude;
	}

	public void setLongitude(BigDecimal longitude) {
		this.longitude = longitude;
	}
    
}
