package org.sp.model;

import java.util.ArrayList;
import java.util.List;

/**
 * A Track Segment holds a list of Track Points which are logically connected in order. 
 * To represent a single GPS track where GPS reception was lost, or the GPS receiver was
 *  turned off, start a new Track Segment for each continuous span of track data.
 * 
 * @author Peter Lin
 *
 */
public class TrackSegment {
	private List<TrackPoint> trackPoints = new ArrayList<TrackPoint>();
	private Extension extensions;
	
	public TrackSegment() {
		super();
	}

	public List<TrackPoint> getTrackPoints() {
		return trackPoints;
	}

	public void setTrackPoints(List<TrackPoint> trackPoints) {
		this.trackPoints = trackPoints;
	}

	public Extension getExtensions() {
		return extensions;
	}

	public void setExtensions(Extension extensions) {
		this.extensions = extensions;
	}
	
}
