package org.sp.utils;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import com.garmin.xmlschemas.trackpointextension.v1.TrackPointExtensionT;
import com.topografix.gpx._1._1.GpxType;

import junit.framework.TestCase;

public class GPXTransformTest extends TestCase {

	public GPXTransformTest() {
	}

	public GPXTransformTest(String name) {
		super(name);
	}

	public void testTransform() {
		String file = "./samples/Cyclemeter-Cycle-rose32-4-28.gpx";
		JAXBElement gpxobj = null;
		try {
			JAXBContext context = JAXBContext.newInstance(GpxType.class);
			gpxobj = (JAXBElement)context.createUnmarshaller().unmarshal(new java.io.File(file));
			assertTrue(gpxobj != null);
			GPXTransform transform = new GPXTransform();
			if (gpxobj != null && gpxobj.getValue() instanceof GpxType) {
				GpxType gpxType = (GpxType)gpxobj.getValue();
				org.sp.model.GPX modelGPX = transform.normalize(gpxType);
				assertTrue(modelGPX != null);
				System.out.println(modelGPX.getCreator());
			}
		} catch (JAXBException e) {
			e.printStackTrace();
			fail();
		}

	}
}
