package starter.data;

import java.util.ArrayList;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;

public class RegisterTestCases {

	int startElementsSize;
	
	public void runTestCases(ArrayList<String> codeInjection,
			int codeInjectionSize) throws InterruptedException {
		ArrayList<String> webElements = new ArrayList<String>();
		webElements.add("display_name");
		webElements.add("email");
		webElements.add("password");
		webElements.add("password_retype");
	
		codeInjection(codeInjection, codeInjectionSize, webElements);
		
		codeInjectionEmailIsEmailType(codeInjection, codeInjectionSize, webElements);
		
		emtyUsername(webElements);
		
		emptyEmail(webElements);
		
		invalidEmailFormat(webElements);
		
		emptyPassword(webElements);
		
		emptyRetypePassword(webElements);
		
		passwordNotMismatch(webElements);
		
		registredSuccesfull(webElements);
	}

	private void registredSuccesfull(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("its");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("its@its.its");
		WebElement password = driver.findElement(By.name(webElements.get(2)));
		password.sendKeys("its");
		WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void passwordNotMismatch(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("its");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("its@its.its");
		WebElement password = driver.findElement(By.name(webElements.get(2)));
		password.sendKeys("it");
		WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void emptyRetypePassword(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("its");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("its@its.its");
		WebElement password = driver.findElement(By.name(webElements.get(2)));
		password.sendKeys("its");
		WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void emptyPassword(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("its");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("its@its.its");
		WebElement password = driver.findElement(By.name(webElements.get(2)));
		password.sendKeys("");
		WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void invalidEmailFormat(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("its");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("itsits.its");
		WebElement password = driver.findElement(By.name(webElements.get(2)));
		password.sendKeys("its");
		WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void emptyEmail(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("its");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("");
		WebElement password = driver.findElement(By.name(webElements.get(2)));
		password.sendKeys("its");
		WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void emtyUsername(ArrayList<String> webElements) {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://www.snapsation.com/login/signUpWithEmail");
		WebElement display_name = driver.findElement(By.name(webElements.get(0)));
		display_name.sendKeys("");
		WebElement email = driver.findElement(By.name(webElements.get(1)));
		email.sendKeys("its@its.its");
		WebElement password = driver.findElement(By.name(webElements.get(3)));
		password.sendKeys("its");
		WebElement password_retype = driver.findElement(By.name(webElements.get(4)));
		password_retype.sendKeys("its");
		display_name.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void codeInjection(ArrayList<String> codeInjection,
			int codeInjectionSize, ArrayList<String> webElements) {
		for(startElementsSize = 0; startElementsSize < codeInjectionSize; startElementsSize++){
			WebDriver driver = new FirefoxDriver();
			driver.get("https://www.snapsation.com/login/signUpWithEmail");
			try {
				Thread.sleep(1800);
			} catch (InterruptedException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			WebElement display_name = driver.findElement(By.name(webElements.get(0)));
			display_name.sendKeys(codeInjection.get(startElementsSize));
			WebElement email = driver.findElement(By.name(webElements.get(1)));
			email.sendKeys(codeInjection.get(startElementsSize));
			WebElement password = driver.findElement(By.name(webElements.get(2)));
			password.sendKeys(codeInjection.get(startElementsSize));
			WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
			password_retype.sendKeys(codeInjection.get(startElementsSize));
			display_name.submit();
			try {
				Thread.sleep(1800);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	private void codeInjectionEmailIsEmailType(ArrayList<String> codeInjection,
			int codeInjectionSize, ArrayList<String> webElements) {
		for(startElementsSize = 0; startElementsSize < codeInjectionSize; startElementsSize++){
			WebDriver driver = new FirefoxDriver();
			driver.get("https://www.snapsation.com/login/signUpWithEmail");
			try {
				Thread.sleep(1800);
			} catch (InterruptedException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			WebElement display_name = driver.findElement(By.name(webElements.get(0)));
			display_name.sendKeys(codeInjection.get(startElementsSize));
			WebElement email = driver.findElement(By.name(webElements.get(1)));
			email.sendKeys("test@test.com");
			WebElement password = driver.findElement(By.name(webElements.get(2)));
			password.sendKeys(codeInjection.get(startElementsSize));
			WebElement password_retype = driver.findElement(By.name(webElements.get(3)));
			password_retype.sendKeys(codeInjection.get(startElementsSize));
			display_name.submit();
			try {
				Thread.sleep(1800);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

}
