package testrunner.core;

import starter.core.SoftwareStart;
import testrunner.logic.DecisionParser;
import testrunner.ui.SnapSationTesterDecision;
import testrunner.ui.UserDecision;

public class TestRunner implements Runnable_Interface, UserDecidable_Interface, DecisionVerificable_Interface, SnapSationTesterDecidable_Interface, SoftwareStartable_Interface {

	@Override
	public void run() throws InterruptedException {
		String userDecision = getUserDecisionFromUser();
		if(howDoesUserDecide(userDecision) == true){
			
			String testDecision = getSnapSationTesterDecision();
			softwareStart(testDecision);
			
		}
		else {
			System.exit(0);
		}
		
	}

	public String getUserDecisionFromUser() {
		UserDecision decision = new UserDecision();
		String userDecision = decision.userMessage();
		return userDecision;
	}

	@Override
	public boolean howDoesUserDecide(String decision) throws InterruptedException {
		DecisionParser decisionParser = new DecisionParser();
		boolean status = decisionParser.verify(decision);
		return status;
	}

	@Override
	public String getSnapSationTesterDecision() {
		
		SnapSationTesterDecision snapSationTesterDecision = new SnapSationTesterDecision();
		String testerDecision = snapSationTesterDecision.userMessage();
		return testerDecision;
	}

	@Override
	public void softwareStart(String testDecision) throws InterruptedException {
		SoftwareStart softwareStart = new SoftwareStart();
		softwareStart.run(testDecision);
		
	}

}
