package Domain;


import java.util.ArrayList;
import java.util.Date;


public class Trip {
        private ArrayList<FlightInstance> flights;
        private float totalCost;
        private Date totalTime;
		
        public Trip(ArrayList<FlightInstance> flights){
        	this.flights = new ArrayList<FlightInstance>();
        	this.flights.addAll(flights);
        	totalTime = computeTotalTime();
        	totalCost = computeTotalCost();
        }
        
        private float computeTotalCost() {
        	float tmp = 0;
			for(int i=0;i<flights.size();i++)
				tmp+=flights.get(i).getFare();
			boolean same = true;
			for(int i=0;i<flights.size();i++){
				int res = flights.get(0).getAirline().getCode().compareTo(flights.get(i).getAirline().getCode());
				if(res != 0)
					same = false;
			}
			if( same && (flights.size()>=2) )
				tmp = tmp*(1-flights.get(0).getAirline().getDiscount());
			return tmp;
		}

		private Date computeTotalTime(){
			Date tmp = new Date(0);
			
			if(flights.size()>0)
				tmp = new Date(flights.get(flights.size()-1).getArrivalTime().getTime()
        			- flights.get(0).getDepartureTime().getTime()-60*60*1000);
        	
        	return tmp;
        }
        
        public int size(){
        	return flights.size();
        }
        
        public FlightInstance getFlightInstance(int i){
        	return flights.get(i);
        }
        
		public float getTotalCost() {
			return totalCost;
		}
		public Date getTotalTime() {
			return totalTime;
		}
        


}
