import java.io.Serializable;
import java.util.*;
import java.text.*;


/**
 * Classe permettant de créer un trajet pour un avion. 
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.O
 */
public class Trajet implements Serializable{
    private int numeroVol;
    private int nombrePlacesOccupees;
    private Calendar dateDepart;
    private Calendar dateArrivee;
    private String villeDepart; // Faire une classe Ville ?
    private String villeArrivee;
    private double prix; // On suppose que toutes les places ont-le même prix ?

    /**
     * Permet de définir un trajet 
     * @param numeroVol le numéro du vol
     * @param dateDepart date de départ du vol
     * @param dateArrivee date d'arrivée du vol
     * @param villeDepart ville de départ du vol
     * @param villeArrivee ville d'arrivée du vol
     * @param prix prix du vol
     */
    public Trajet(int numeroVol, String dateDepart, String dateArrivee, String villeDepart, String villeArrivee, double prix){
	setDateDepart(dateDepart);
	setDateArrivee(dateArrivee);
	setNumeroVol(numeroVol);
	setVilleDepart(villeDepart);
	setVilleArrivee(villeArrivee);
	setPrix(prix);
	nombrePlacesOccupees = 0;
    }
    
    /**
     * Retourne le numéro du vol
     * @return le numéro du vol
     */
    public int getNumeroVol(){
	return numeroVol;
    }
    
    /**
     * Retourne le nombre de Places occupées
     * @return nombre de places occupées
     */
    public int getNombrePLacesOccupees(){
	return nombrePlacesOccupees;
    }
    
    /**
     * Retourne la ville de départ
     * @return ville de départ
     */
    public String getVilleDepart(){
	return villeDepart;
    }

    /** 
     * Retourne la ville d'arrivée
     */
    public String getVilleArrivee(){
	return villeArrivee;
    }

    /** 
     * Retourne le prix du vol
     * @return prix du vol
     */
    public double getPrix(){
	return prix;
    }

    /**
     * Retourne la date de départ du vol
     * @return date de départ du vol
     */
    public Calendar getDateDepart(){
	return dateDepart;
    }
    
    /**
     * Retourne la date d'arrivée du vol
     * @return date d'arrivée du vol
     */
    public Calendar getDateArrivee(){
	return dateArrivee;
    }

    /**
     * Permet de définir un numéro de vol ( positif )
     * @param numeroVol numéro de vol
     */
    public void setNumeroVol(int numeroVol){
	if( numeroVol < 0 ){
	    System.err.println("Le numéro de vol rentré est négatif !");
	}
	else{
	    this.numeroVol = numeroVol;
	}
    }

    /**
     * Permet de définir une ville de départ
     * @param villeDepart ville de départ
     */
    public void setVilleDepart(String villeDepart){
	this.villeDepart = villeDepart;
    }

    /**
     * Permet de définir une heure d'arrivée
     * @param villeArrivee ville d'arrivée
     */
    public void setVilleArrivee(String villeArrivee){
	this.villeArrivee = villeArrivee;
    }

    /** 
     * Permet de définir un prix
     * @param prix prix du trajet
     */
    public void setPrix(double prix){
	if( prix > 0 ){
	    this.prix = prix;
	}
	else{
	    System.err.println("Le prix rentré est négatif !");
	}
    }
    
    /**
     * Permet de définir une date de départ dans un format définit
     * @param dateDepart date de départ souhaitée
     */
    public void setDateDepart(String dateDepart){
	try {
	    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
	    Date date = format.parse(dateDepart);
	    this.dateDepart = Calendar.getInstance();
	    this.dateDepart.setTime(date);
	} catch (ParseException e) {
	    System.out.println("Exception :"+e);
	}
    }

    /**
     * Permet de définir une date d'arrivée dans un format définit
     * @param dateArrivee date d'arrivée souhaitée
     */
    public void setDateArrivee(String dateArrivee){
	try {
	    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
	    Date date = format.parse(dateArrivee);
	    this.dateArrivee = Calendar.getInstance();
	    this.dateArrivee.setTime(date); 
	} catch (ParseException e) {
	    System.out.println("Exception :"+e);
	}
	if( this.dateArrivee.before(this.dateDepart) == true ){
	    System.err.println("La date d'arrivée est avant la date de départ");
	}
    }
    
    /**
     * Permet d'afficher la date de départ du vol avec sa date et son heure
     * @return chaîne de caractère décrivant la date départ d'un vol
     */
    public String afficherDateDepart(){
	int moisDepart_int = dateDepart.get(Calendar.MONTH)+1;
	String moisDepart_string = "";
	return dateDepart.get(Calendar.DAY_OF_MONTH) + "/" + (moisDepart_string).valueOf(moisDepart_int) + "/" + dateDepart.get(Calendar.YEAR) + " " + dateDepart.get(Calendar.HOUR_OF_DAY) + ":" + dateDepart.get(Calendar.MINUTE);
    }

    /**
     * Permet d'afficher la date d'arrivée du vol avec sa date et son heure
     * @return chaîne de caractère décrivant la date d'arrivée d'un vol
     */
    public String afficherDateArrivee(){
	int moisArrivee_int = dateArrivee.get(Calendar.MONTH)+1;
	String moisArrivee_string = "";
	return dateArrivee.get(Calendar.DAY_OF_MONTH) + "/" + (moisArrivee_string).valueOf(moisArrivee_int) + "/" + dateArrivee.get(Calendar.YEAR) + " " + dateArrivee.get(Calendar.HOUR_OF_DAY) + ":" + dateArrivee.get(Calendar.MINUTE);
    }

 
    /**
     * Ajoute X places occupées au trajet
     * @param nombre de places occupées à ajouterµ
     */
    public void ajouterXPlacesOccupees(int x){
	nombrePlacesOccupees += x;
    }
    
    /**
     * Retourne une chaîne de caractères décrivant un trajet
     * @return chaîne de caractères décrivant un trajet
     */
    public String toString(){
	int moisDepart_int = dateDepart.get(Calendar.MONTH)+1;
	String moisDepart_string = "";
	int moisArrivee_int = dateDepart.get(Calendar.MONTH)+1;
	String moisArrivee_string = "";
	return "N° du vol : " + numeroVol + "\n Départ :  " + villeDepart + ", le " + dateDepart.get(Calendar.DAY_OF_MONTH ) + "/" + moisDepart_string.valueOf(moisDepart_int) + "/" + dateDepart.get(Calendar.YEAR) + " à " + dateDepart.get(Calendar.HOUR_OF_DAY) + ":" + dateDepart.get(Calendar.MINUTE) + "\n Retour : " + villeArrivee + ", le " + dateArrivee.get(Calendar.DAY_OF_MONTH) + "/" + moisArrivee_string.valueOf(moisArrivee_int) + "/" + dateArrivee.get(Calendar.YEAR) + " à " + dateArrivee.get(Calendar.HOUR_OF_DAY) + ":" + dateArrivee.get(Calendar.MINUTE) + "\n Durée : A COMPLETER" + "\n Prix : " + prix + " euros ";
    } 
   

}