//package gestionreservation;

import java.io.Serializable;

/**
 * Classe permettant de créer un trajet pour un avion. 
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.O
 */
public class Trajet implements Serializable{
    private int numeroVol;
    private int nombrePlacesOccupees;
    private String dateDepart; // Jour
    private String dateArrivee; // Jour 
    private String heureDepart;
    private String heureArrivee;
    private String villeDepart; // Faire une classe Ville ?
    private String villeArrivee;
    private double prix; // On suppose que toutes les places ont-le même prix ?

    /**
     * Construit un trajet
     * @param numeroVol le numéro du vol
     * @param dateDepart la date de Départ
     * @param dateArrivee la date d'arrivée
     * @param heureDepart l'heure de départ
     * @param heureArrivee l'heure d'arrivée
     * @param villeDepart la ville de départ
     * @param villeArrivee la ville d'arrivée
     * @param prix le prix du vol
     */
    public Trajet(int numeroVol, String dateDepart, String dateArrivee, String heureDepart, String heureArrivee, String villeDepart, String villeArrivee, double prix){
	setNumeroVol(numeroVol);
	setDateDepart(dateDepart);
	setDateArrivee(dateArrivee);
	setHeureDepart(heureDepart);
	setHeureArrivee(heureArrivee);
	setVilleDepart(villeDepart);
	setVilleArrivee(villeArrivee);
	setPrix(prix);
	nombrePlacesOccupees = 0;
    }
    
    /**
     * Retourne le numéro du vol
     * @return le numéro du vol
     */
    public int getNumeroVol(){
	return numeroVol;
    }
    
    /**
     * Retourne le nombre de Places occupées
     * @return nombre de places occupées
     */
    public int getNombrePLacesOccupees(){
	return nombrePlacesOccupees;
    }

    /** 
     * Retourne la date de départ
     * @return date de départ
     */
    public String getDateDepart(){
	return dateDepart;
    }
    
    /**
     * Retourne la date d'arrivée
     * @return date d'arrivée
     */
    public String getDateArrivee(){
	return dateArrivee;
    }

    /** 
     * Retourne l'heure de départ
     * @return heure de départ
     */
    public String getHeureDepart(){
	return heureDepart;
    }

    /**
     * Retourne l'heure d'arrivée
     * @return heure d'arrivée
     */
    public String getHeureArrivee(){
	return heureArrivee;
    }
    
    /**
     * Retourne la ville de départ
     * @return ville de départ
     */
    public String getVilleDepart(){
	return villeDepart;
    }

    /** 
     * Retourne la ville d'arrivée
     */
    public String getVilleArrivee(){
	return villeArrivee;
    }

    /** 
     * Retourne le prix du vol
     * @return prix du vol
     */
    public double getPrix(){
	return prix;
    }

    /**
     * Permet de définir un numéro de vol ( positif )
     * @param numeroVol numéro de vol
     */
    public void setNumeroVol(int numeroVol){
	if( numeroVol < 0 ){
	    System.err.println("Le numéro de vol rentré est négatif !");
	}
	else{
	    this.numeroVol = numeroVol;
	}
    }

    /**
     * Permet de définir une date de départ
     * Précondition : Ne rentrer que des entiers et une date sous le format JJ/MM/AAAA
     * @param dateDepart date de départ
     */
    public void setDateDepart(String dateDepart){
	if( dateDepart.length() == 10 ){
	    this.dateDepart = dateDepart;
	}
	else{
	    System.err.println("Le format de date rentré n'est pas correct");
	}
    }

    /**
     * Permet de définir une date d'arrivée
     * Précondition : Ne rentrer que des entiers et une date sous le format JJ/MM/AAAA
     * @param dateArrivee date d'arrivée
     */
    public void setDateArrivee(String dateArrivee){
	if( dateArrivee.length() == 10 ){
	    this.dateArrivee = dateArrivee;
	}
	else{
	    System.err.println("Le format de date rentré n'est pas correct");
	}
    }

    /**
     * Permet de définir une heure de départ
     * Précondition : Ne rentrer que des entiers et une heure sous le format HH:MM
     * @param heureDepart heure de départ
     */
    public void setHeureDepart(String heureDepart){
	if( heureDepart.length() == 5 ){
	    this.heureDepart = heureDepart;
	}
	else{
	    System.err.println("Le format d'heure rentré n'est pas correct");
	}
    }

    /**
     * Permet de définir une heure d'arrivée
     * Précondition : Ne rentrer que des entiers et une heure sous le format HH:MM
     * @param heureArrivee heure d'arrivée
     */
    public void setHeureArrivee(String heureArrivee){
	if( heureArrivee.length() == 5 ){
	    this.heureArrivee = heureArrivee;
	}
	else{
	    System.err.println("Le format d'heure rentré n'est pas correct");
	}
    }
   
    /**
     * Permet de définir une ville de départ
     * @param villeDepart ville de départ
     */
    public void setVilleDepart(String villeDepart){
	this.villeDepart = villeDepart;
    }

    /**
     * Permet de définir une heure d'arrivée
     * @param villeArrivee ville d'arrivée
     */
    public void setVilleArrivee(String villeArrivee){
	this.villeArrivee = villeArrivee;
    }

    /** 
     * Permet de définir un prix
     * @param prix prix du trajet
     */
    public void setPrix(double prix){
	if( prix > 0 ){
	    this.prix = prix;
	}
	else{
	    System.err.println("Le prix rentré est négatif !");
	}
    }
    

    /**
     * Ajoute X places occupées au trajet
     * @param nombre de places occupées à ajouterµ
     */
    public void ajouterXPlacesOccupees(int x){
	nombrePlacesOccupees += x;
    }
    
    /**
     * Retourne une chaîne de caractères décrivant un trajet
     * @return chaîne de caractères décrivant un trajet
     */ 
    public String toString(){
	return "N° du vol : " + numeroVol + "\n Départ :  " + villeDepart + ", le " + dateDepart + " à " + heureDepart + "\n Retour : " + villeArrivee + ", le " + dateArrivee + " à " + heureArrivee + "\n Durée : A COMPLETER" + "\n Prix : " + prix + " euros ";
    } 
}