import org.jdom.output.*;
import java.util.*;
import java.io.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.filter.*;

/**
 * <code> Classe:TrajetXml <br>permet relier les classes Trajet et  TrajetXml </code>.
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.0
 */


public class TrajetXml {
    private  ArrayList<Trajet> listeTrajet;
    private Document trajXml;

     /**
      *<code> Constructeur: TrajetXml <br>Créé  un fichier XML s'il n'existe, ou sinon créé une liste à partir du fichier XML</code>.
     */
    public TrajetXml() {
	SAXBuilder sxb = new SAXBuilder(false);
	try{
	    File fichierXml=new File("trajets.xml");
	    trajXml = sxb.build(fichierXml);
	    //sxb.setValidation(true);
	}
	catch(Exception e){
	    trajXml = new Document(new Element("trajets"));
	    System.out.println("Bonjour");
	}
	Element racineTrajet = trajXml.getRootElement();
	List listeTr= racineTrajet.getChildren("trajet");
	listeTrajet = new ArrayList<Trajet> ();
	listeTrajet=remplirTrajet(listeTr);
    }
    /**
     * <code>Méthode: enregistreTrajetXml <br> permet d'enregistrer le contenu de la liste dans
     * le fichier XML dedié</code>.
     */
    public void enregistreTrajetXml() {
	try {
		XMLOutputter fichierTrajet = new XMLOutputter(Format.getPrettyFormat());
		fichierTrajet.output(trajXml, new FileOutputStream("trajets.xml"));
	    }catch (java.io.IOException e){
	    System.out.println("Impossible de sauvegarder le fichier trajets.xml "); 
	}
    }
    /**
     * <code>Méthode: enregistreTrajet <br> permet d'enregistrer le contenu de la liste dans
     * le fichier XML dedié</code>.
     * @param liste <code> (la liste qu'il faut enregistrer) </code>
     */
    public void enregistreTrajet(ArrayList<Trajet> liste) {
	this.listeTrajet=liste;
	Iterator iListeTrajet=listeTrajet.iterator();
	boolean ok=true;
	
	

	while(iListeTrajet.hasNext()) {
	    Element trajet=new Element("trajet");
	    Element numerovol=new Element("numerovol");
	    Element nombredeplaceoccupees=new Element("nombredeplaceoccupees");
	    Element datedepart=new Element("datedepart");
	    Element datearrivee=new Element("datearrivee");	    
	    Element heuredepart=new Element("heuredepart");
	    Element heurearrivee=new Element("heurearrivee");
	    Element villedepart=new Element("villedepart");
	    Element villearrivee=new Element("villearrivee");
	    Element prix=new Element("prix");

	    Trajet trajetCourant=(Trajet)iListeTrajet.next();

	    trajet.addContent(numerovol);
	    trajet.addContent(nombredeplaceoccupees);
	    trajet.addContent(datedepart);	    
	    trajet.addContent(datearrivee);
	    trajet.addContent(heuredepart);
	    trajet.addContent(heurearrivee);
	    trajet.addContent(villedepart);
	    trajet.addContent(villearrivee);
	    trajet.addContent(prix);
	    
	    numerovol.setText(String.valueOf(trajetCourant.getNumeroVol()));
	    nombredeplaceoccupees.setText(String.valueOf(trajetCourant.getNombrePLacesOccupees()));
	    datedepart.setText(trajetCourant.getDateDepart());
	    datearrivee.setText(trajetCourant.getDateArrivee());
	    heuredepart.setText(trajetCourant.getHeureDepart());
	    heurearrivee.setText(trajetCourant.getHeureArrivee());
	    villedepart.setText(trajetCourant.getVilleDepart());
	    villearrivee.setText(trajetCourant.getVilleArrivee());
	    prix.setText(String.valueOf(trajetCourant.getPrix()));


	    trajXml.getRootElement().addContent(trajet);			
	    
	}
	    enregistreTrajetXml();
    }
    
    /**
     * <code>Méthode: remplirTrajet <br> permet de remplir la liste de  trajet à partir de 
     * du document xml </code>.
     * @param listeTr <code>List(liste des elements qui sont dans le document) </code>
     * @return ArrayList<Trajet> <code>(liste des trajets) </code>
     */
    public   ArrayList<Trajet> remplirTrajet(List listeTr ) {
	listeTrajet = new ArrayList<Trajet> ();
	Iterator iListeTr = listeTr.iterator();

	while(iListeTr.hasNext()) {
	    Element trajetCourant=(Element)iListeTr.next();
	    int numeroVol=Integer.parseInt((trajetCourant.getChildText("numerovol")));
	    int nombrePlacesOccupees=Integer.parseInt((trajetCourant.getChildText("nombredeplaceoccupees")));
	    String dateDepart=trajetCourant.getChildText("datedepart");
	    String dateArrivee=trajetCourant.getChildText("datearrivee");	   
	    String heureDepart=trajetCourant.getChildText("heuredepart");
	    String heureArrivee=trajetCourant.getChildText("heurearrivee");
	    String villeDepart=trajetCourant.getChildText("villedepart");
	    String villeArrivee=trajetCourant.getChildText("villearrivee");
	    double prix=Double.parseDouble(trajetCourant.getChildText("prix"));

	    Trajet trajet = new Trajet(numeroVol,dateDepart,dateArrivee,heureDepart,heureArrivee,villeDepart,villeArrivee,prix );
	    listeTrajet.add(trajet);
	   
	}
	return listeTrajet;
    }

    /**<code> Méthode: addTrajet <br> ajoute un nouveau trajet à la liste de trajet </code>
     * @param nouveauTrajet <code> représente le nouveau trajet </code>
     */
    public void addTrajet(Trajet nouveauTrajet) {
	listeTrajet.add(nouveauTrajet);
    }
    
    /**<code> Méthode: removeTrajet <br> supprime l'ancien trajet s'il est dans la liste </code>
     * @param ancienTrajet <code> représente le trajet à supprimer </code>
     */
    public boolean removeTrajet(Trajet ancienTrajet){
	return listeTrajet.remove(ancienTrajet);
    }
    
    /** <code> Méthode: toString  permet de lister tous les trajets existants </code>
     *  @return <code> String  </code> 
     */
    public String toString() {
	String chaineFormat="";

	for(Trajet trajet: listeTrajet) 
	    chaineFormat+=trajet+"\n";
	return chaineFormat;
    }

}	    