/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */



package demo.hello;

import java.io.*;
import org.omg.CORBA.*;

public class Client {
    public static void main(String args[]) {
        if (args.length != 1) {
            System.out.println("Usage: demo.hello.Client <ior_file>");
            System.exit(1);
        }
        try {
            String fileName = new String(args[0]);

            // initialize the ORB.
            
            java.util.Properties props = new java.util.Properties();
            
            props.setProperty("org.omg.CORBA.ORBClass", "org.huihoo.orbas.orb.ORB");
            props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.huihoo.orbas.orb.ORBSingleton");
            
            org.huihoo.orbas.orb.ORB orb = (org.huihoo.orbas.orb.ORB)ORB.init(args, props);
            
            FileInputStream f = new FileInputStream(fileName);
            byte[] buf = new byte[f.available()];

            f.read(buf, 0, f.available());
            String ior = new String(buf);

            org.omg.CORBA.Object obj = orb.string_to_object(ior);
//            org.omg.CORBA.Object obj = orb.resolve_binding("HelloServer");
            
            // and narrow it to HelloWorld.GoodDay
            // if this fails, a BAD_PARAM will be thrown
            HelloObj helloObject = HelloObjHelper.narrow(obj);
            // invoke the operation and print the result
            for(;;) {
                System.out.println(helloObject.getHelloString("say hello"));
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }
}
