/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */



package demo.nametest;

import java.io.*;
import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import demo.hello.*;

public class NameClient {
    public static void main(String args[]) {

        try {

            // initialize the ORB.

            java.util.Properties props = new java.util.Properties();

            props.setProperty("org.omg.CORBA.ORBClass",
                              "org.huihoo.orbas.orb.ORB");
            props.setProperty("org.omg.CORBA.ORBSingletonClass",
                              "org.huihoo.orbas.orb.ORBSingleton");

            ORB orb = ORB.init(args, props);
            //
            org.omg.CORBA.Object obj = orb.resolve_initial_references(
                "NameService");
            NamingContextExt context = NamingContextExtHelper.narrow(obj);
            //build the name "demohello" to get the HelloObj.
            NameComponent n = new NameComponent();
            n.id = "demohello";
            n.kind = "";
            NameComponent[] nc = new NameComponent[1];
            nc[0] = n;
            //Get the HelloObj from NameService with name "demohello"
            org.omg.CORBA.Object result = context.resolve(nc);
            HelloObj hello = HelloObjHelper.narrow( result );
            //Invoke the HelloObjet method to complete the business.
            System.out.println(hello.getHelloString("My NameService Hello."));

        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }
}
