/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class AnyType extends BaseType {

	public AnyType(int num) {
		super(num);
	}

	public Object clone() {
		return new AnyType(new_num());
	}

	public String typeName() {
		return "org.omg.CORBA.Any";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public boolean basic() {
		return false;
	}

	public String toString() {
		return typeName();
	}

	public String holderName() {
		return "org.omg.CORBA.AnyHolder";
	}

	public void parse()

	{
	}

	public int getTCKind() {
		return 11;
	}

	public String printReadExpression(String strname) {
		return strname + ".read_any()";
	}

	public String printWriteStatement(String var_name, String strname) {
		return strname + ".write_any(" + var_name + ");";
	}

}
