/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

class ArrayDeclarator extends Declarator {

	public SymbolList fixed_array_size_list;
	private int[] dimensions = null;

	public ArrayDeclarator(int num) {
		super(num);
	}

	public String name() {
		return name;
	}

	/**
	 * @overrides escapeName from Declarator
	 */

	public void escapeName() {
		if (!name.startsWith("_") && lexer.strictJavaEscapeCheck(name)) {
			name = "_" + name;
		}
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;

		for (Enumeration e = fixed_array_size_list.v.elements(); e
				.hasMoreElements(); ((FixedArraySize) e.nextElement())
				.setPackage(s))
			;

	}

	/**
	 * only needed to overwrite the delegating full_name() method from
	 * superclass Declarator, identical to method in class IdlSymbol
	 */

	String full_name() {
		if (name.length() == 0)
			return null;
		if (pack_name.length() > 0)
			return pack_name + "." + name;
		else
			return name;
	}

	public void parse() {
		for (Enumeration e = fixed_array_size_list.v.elements(); e
				.hasMoreElements(); ((FixedArraySize) e.nextElement()).parse())
			;

		for (Enumeration e = fixed_array_size_list.v.elements(); e
				.hasMoreElements();)
			((FixedArraySize) e.nextElement()).parse();
	}

	public void define() {
		try {
			NameTable.define(full_name(), "type");
		} catch (NameAlreadyDefined p) {
			// parser.error("Array declarator " +
			// full_name() + " already declared",p_info);
		}
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
	}

	public IdlSymbol getEnclosingSymbol() {
		return enclosing_symbol;
	}

	public int[] dimensions() {
		if (dimensions == null) {
			Vector dynlist = new Vector();
			for (Enumeration e = fixed_array_size_list.v.elements(); e
					.hasMoreElements();)
				dynlist.addElement(new Integer(((FixedArraySize) e
						.nextElement()).value()));
			dimensions = new int[dynlist.size()];
			for (int i = 0; i < dimensions.length; i++)
				dimensions[i] = ((Integer) dynlist.elementAt(i)).intValue();

		}
		return dimensions;
	}

	public String toString() {
		return name();
	}

	public void print(PrintWriter ps) {
	}

}
