/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class BaseType extends SimpleTypeSpec {

	public BaseType(int num) {
		super(num);
	}

	/** ignore, these types don't need to know their package */
	public void setPackage(String s) {
		s = parser.pack_replace(s);
	}

	public TypeSpec typeSpec() {
		return type_spec.typeSpec();
	}

	public boolean basic() {
		return type_spec.basic();
	}

	public boolean isSwitchType() {
		return (type_spec instanceof SwitchTypeSpec && ((SwitchTypeSpec) type_spec)
				.isSwitchable());
	}

	public void parse() {
	}

	public static boolean isBasicName(String typeName) {
		return (typeName.startsWith("long") || typeName.startsWith("int")
				|| typeName.startsWith("short") || typeName.startsWith("float")
				|| typeName.startsWith("double") || typeName.startsWith("byte")
				|| typeName.startsWith("boolean")
				|| typeName.startsWith("char") || typeName.startsWith("string"));
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
	}

	/** the "kind of TypeCode" for this type */

	public int getTCKind() {
		return ((BaseType) type_spec).getTCKind();
	}

	protected String typeCodeExpressionSkeleton(int kind) {
		return "org.omg.CORBA.ORB.init().get_primitive_tc("
				+ "org.omg.CORBA.TCKind.from_int(" + kind + "))";
	}

	public String getTypeCodeExpression() {
		return typeCodeExpressionSkeleton(getTCKind());
	}

	public String toString() {
		if (type_spec != null)
			return type_spec.toString();
		else
			return "BaseType";
	}

	public String typeName() {
		return type_spec.typeName();
	}

	public String id() {
		return "IDL:*primitive*:1.0";
	}

	public void print(PrintWriter ps) {
	}

}
