/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class ConstType extends IdlSymbol {
	TypeSpec symbol;

	public ConstType(int num) {
		super(num);
	}

	public void parse() {
		if (symbol.typeSpec() instanceof ScopedName) {
			TypeSpec ts = ((ScopedName) symbol.typeSpec()).resolvedTypeSpec();
			if (ts != null)
				symbol = ts;
		}
		symbol.parse();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;

		symbol.setPackage(s);
	}

	public String toString() {
		return symbol.toString();
	}
}
