/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class Definition extends IdlSymbol {

	private Declaration declaration;

	public Definition(int num) {
		super(num);
		pack_name = "";
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		super.setPackage(s);
		declaration.setPackage(s);
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s) {
			System.err.println("was " + enclosing_symbol.getClass().getName()
					+ " now: " + s.getClass().getName());
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		}
		enclosing_symbol = s;
		declaration.setEnclosingSymbol(s);
	}

	public Declaration get_declaration() {
		return declaration;
	}

	public void set_declaration(Declaration d) {
		declaration = d;
	}

	public void set_included(boolean i) {
		included = i;
		declaration.set_included(i);
	}

	public void print(PrintWriter ps) {
		declaration.print(ps);
	}

	public void parse() {
		declaration.parse();
	}
}
