/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

class Definitions extends SymbolList {

	public Definitions(int num) {
		super(num);
		v = new Vector();
		Enumeration e = v.elements();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		Enumeration e = v.elements();
		for (; e.hasMoreElements();) {
			IdlSymbol i = (IdlSymbol) e.nextElement();
			i.setPackage(s);
		}
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s) {
			System.err.println("was " + enclosing_symbol.getClass().getName()
					+ " now: " + s.getClass().getName());
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		}
		enclosing_symbol = s;
		for (Enumeration e = v.elements(); e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).setEnclosingSymbol(s);
	}

	public void set_included(boolean i) {
		included = i;
		Enumeration e = v.elements();
		for (; e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).set_included(i);
	}

	public void print(PrintWriter ps) {
		Enumeration e = v.elements();
		for (; e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).print(ps);
	}
}
