/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class DoubleType extends FloatPtType {

	public DoubleType(int num) {
		super(num);
	}

	public String typeName() {
		return "double";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		return 7;
	}

	public String toString() {
		return typeName();
	}

	public String holderName() {
		return "org.omg.CORBA.DoubleHolder";
	}

	public String printReadExpression(String strname) {
		return strname + ".read_double()";
	}

	public String printWriteStatement(String var_name, String strname) {
		return strname + ".write_double(" + var_name + ");";
	}

	public String printInsertExpression() {
		return "insert_double";
	}

	public String printExtractExpression() {
		return "extract_double";
	}

}
