/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class ElementSpec extends IdlSymbol {

	public TypeSpec t = new TypeSpec(new_num());
	public Declarator d = null;
	private UnionType containingUnion;

	public ElementSpec(int num) {
		super(num);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		t.setPackage(s);
		d.setPackage(s);
	}

	public void setUnion(UnionType ut) {
		containingUnion = ut;
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		t.setEnclosingSymbol(s);
		d.setEnclosingSymbol(s);
	}

	public void parse() {
		if (t.typeSpec() instanceof TemplateTypeSpec
				|| t.typeSpec() instanceof ConstrTypeSpec) {
			t.parse();
			if (t.typeSpec() instanceof SequenceType) {
				TypeSpec ts = ((SequenceType) t.typeSpec()).elementTypeSpec()
						.typeSpec();
				SequenceType seqTs = (SequenceType) t.typeSpec();
				while (ts instanceof SequenceType) {
					seqTs = (SequenceType) ts;
					ts = ((SequenceType) ts.typeSpec()).elementTypeSpec()
							.typeSpec();
				}

				// if( ts.typeName().equals( containingUnion.typeName() ) ||
				if (ScopedName.isRecursionScope(ts.typeName())) {
					((SequenceType) seqTs.typeSpec()).setRecursive();
				}
			}
		} else if (t.typeSpec() instanceof ScopedName) {
			TypeSpec ts = ((ScopedName) t.typeSpec()).resolvedTypeSpec();
			if (ts.typeName().equals(containingUnion.typeName())) {
				parser.error(
						"Illegal recursion in union "
								+ containingUnion.full_name(), token);
			}

			containingUnion.addImportedName(ts.typeName());

			if (ts != null)
				t = ts;
		}

		try {
			NameTable.define(containingUnion.full_name() + "." + d.name(),
					"declarator");
		} catch (NameAlreadyDefined nad) {
			parser.error(
					"Declarator " + d.name() + " already defined in union "
							+ containingUnion.full_name(), token);
		}
		// d.parse();
	}

	public void print(java.io.PrintWriter ps) {
		if (t.typeSpec() instanceof TemplateTypeSpec
				|| t.typeSpec() instanceof ConstrTypeSpec) {
			t.print(ps);
		}
	}

}
