/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class FloatType extends FloatPtType {

	public FloatType(int num) {
		super(num);
	}

	public String typeName() {
		return "float";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		return 6;
	}

	public String toString() {
		return typeName();
	}

	public String holderName() {
		return "org.omg.CORBA.FloatHolder";
	}

	public String printReadExpression(String strname) {
		return strname + ".read_float()";
	}

	public String printWriteStatement(String var_name, String strname) {
		return strname + ".write_float(" + var_name + ");";
	}

	public String printInsertExpression() {
		return "insert_float";
	}

	public String printExtractExpression() {
		return "extract_float";
	}
}
