/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

class InitDecl extends Declaration {
	public Vector paramDecls;
	public IdlSymbol myValue;

	public InitDecl(int num) {
		super(num);
		paramDecls = new Vector();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);

		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;

		for (Enumeration e = paramDecls.elements(); e.hasMoreElements(); ((ParamDecl) e
				.nextElement()).setPackage(s))
			;
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
	}

	public void parse() {
		myValue = enclosing_symbol;

		try {
			NameTable.define(full_name(), "factory");
		} catch (NameAlreadyDefined nad) {
			parser.error("Factory " + full_name() + " already defined", token);
		}

		for (Enumeration e = paramDecls.elements(); e.hasMoreElements();) {
			ParamDecl param = (ParamDecl) e.nextElement();
			param.parse();
			try {
				NameTable.define(
						full_name() + "." + param.simple_declarator.name(),
						"argument");
			} catch (NameAlreadyDefined nad) {
				parser.error("Argument " + param.simple_declarator.name()
						+ " already defined in operation " + full_name(), token);
			}
		}
	}

	public void print(PrintWriter ps, String type_name) {
		ps.print("\t" + type_name + " " + name + "( ");

		Enumeration e = paramDecls.elements();

		if (e.hasMoreElements())
			((ParamDecl) e.nextElement()).print(ps);

		for (; e.hasMoreElements();) {
			ps.print(", ");
			((ParamDecl) e.nextElement()).print(ps);
		}
		ps.println(");");
	}

	public String name() {
		return name;
	}

	public String opName() {
		return name();
	}

}
