/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class LongType extends IntType {

	public LongType(int num) {
		super(num);
	}

	public Object clone() {
		return new LongType(new_num());
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public String typeName() {
		return "int";
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		return ((unsigned) ? 5 : 3);
	}

	public String toString() {
		return typeName();
	}

	public String holderName() {
		return "org.omg.CORBA.IntHolder";
	}

	public String printReadExpression(String ps) {
		if (unsigned)
			return ps + ".read_ulong()";
		else
			return ps + ".read_long()";
	}

	public String printWriteStatement(String var_name, String ps) {
		if (unsigned)
			return ps + ".write_ulong(" + var_name + ");";
		else
			return ps + ".write_long(" + var_name + ");";
	}

	public String printInsertExpression() {
		if (unsigned)
			return "insert_ulong";
		else
			return "insert_long";
	}

	public String printExtractExpression() {
		if (unsigned)
			return "extract_ulong";
		else
			return "extract_long";
	}
}
