/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.util.Enumeration;
import java.util.Vector;

class MemberList extends SymbolList {
	Vector extendVector = new Vector();
	private TypeDeclaration containingType;
	private boolean parsed = false;

	public MemberList(int num) {
		super(num);
	}

	public void setContainingType(TypeDeclaration t) {
		containingType = t;
		Enumeration e = v.elements();
		for (; e.hasMoreElements();) {
			Member m = (Member) e.nextElement();
			m.setContainingType(t);
		}
	}

	public void parse() {
		if (parsed)
			throw new RuntimeException(
					"Compiler error: MemberList already parsed!");

		Enumeration e = v.elements();
		for (; e.hasMoreElements();) {
			Member m = (Member) e.nextElement();
			m.setExtendVector(extendVector);
			m.parse();
		}

		/*
		 * after all members are parsed, we have accumulated a new member list
		 * in "normal form" in extendVector
		 */

		v = extendVector;
		parsed = true;

	}

	public void setEnclosingSymbol(IdlSymbol s) {

		if (enclosing_symbol != null && enclosing_symbol != s) {
			System.err.println("was " + enclosing_symbol.getClass().getName()
					+ " now: " + s.getClass().getName());

			throw new RuntimeException(
					"Compiler Error: trying to reassign container");
		}

		enclosing_symbol = s;

		for (Enumeration e = v.elements(); e.hasMoreElements();) {
			Member m = (Member) e.nextElement();
			m.setEnclosingSymbol(s);
		}
	}

}
