/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class MultExpr extends IdlSymbol {

	public String operator;
	public MultExpr mult_expr = null;
	public UnaryExpr unary_expr;

	public MultExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		if (mult_expr != null) {
			mult_expr.print(ps);
			ps.print(operator);
		}
		unary_expr.print(ps);
	}

	public void setDeclaration(ConstDecl declared_in) {
		unary_expr.setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		if (mult_expr != null) {
			mult_expr.setPackage(s);
		}
		unary_expr.setPackage(s);
	}

	public void parse() {
		if (mult_expr != null) {
			mult_expr.parse();
		}
		unary_expr.parse();
	}

	int pos_int_const() {
		int y = unary_expr.pos_int_const();
		if (mult_expr != null) {
			int z = mult_expr.pos_int_const();
			if (operator.equals("*"))
				y *= z;
			else if (operator.equals("/"))
				y /= z;
			else if (operator.equals("%"))
				y %= z;
		}
		return y;
	}

	public String value() {
		String x = "";
		if (mult_expr != null) {
			x = mult_expr.value() + operator;
		}
		return x + unary_expr.value();
	}

	public String toString() {
		String x = "";
		if (mult_expr != null) {
			x = mult_expr + operator;
		}
		return x + unary_expr.toString();
	}

	public str_token get_token() {
		return unary_expr.get_token();
	}

}
