/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class NativeType extends TypeDeclaration {

	SimpleDeclarator declarator;

	public NativeType(int num) {
		super(num);
		pack_name = "";
	}

	public Object clone() {
		NativeType nt = new NativeType(new_num());
		nt.declarator = this.declarator;
		nt.pack_name = this.pack_name;
		return nt;
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
	}

	public TypeDeclaration declaration() {
		return this;
	}

	public String typeName() {
		if (pack_name.length() > 0)
			return ScopedName.unPseudoName(pack_name + "." + name);
		else
			return ScopedName.unPseudoName(name);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
	}

	public boolean basic() {
		return true;
	}

	public String toString() {
		return typeName();
	}

	public void set_included(boolean i) {
		included = i;
	}

	public void parse()

	{
		// don't parse the declarator as that would define its
		// name which is to be defined as part of this type name

		name = declarator.name();
		is_pseudo = true;

		ConstrTypeSpec ctspec = new ConstrTypeSpec(new_num());
		try {
			ctspec.c_type_spec = this;
			NameTable.define(full_name(), "native");
			TypeMap.typedef(full_name(), ctspec);
		} catch (NameAlreadyDefined n) {
			parser.fatal_error("Name already defined", token);
		}
	}

	public String holderName() {
		return typeName() + "Holder";
	}

	public String printReadExpression(String Streamname) {
		return full_name() + "Helper.read(" + Streamname + ")";
	}

	public String printWriteStatement(String var_name, String Streamname) {
		return full_name() + "Helper.write(" + Streamname + "," + var_name
				+ ");";
	}

	public void print(PrintWriter ps) {
	}

}
