/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class OctetType extends BaseType {

	public OctetType(int num) {
		super(num);
	}

	public Object clone() {
		return new OctetType(new_num());
	}

	public String typeName() {
		return "byte";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public String toString() {
		return typeName();
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		return 10;
	}

	public void parse()

	{
	}

	public String holderName() {
		return "org.omg.CORBA.ByteHolder";
	}

	public String printReadExpression(String strname) {
		return strname + ".read_octet()";
	}

	public String printWriteStatement(String var_name, String strname) {
		return strname + ".write_octet(" + var_name + ");";
	}

	public String printInsertExpression() {
		return "insert_octet";
	}

	public String printExtractExpression() {
		return "extract_octet";
	}

}
