/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.io.Serializable;

interface Operation extends Serializable {

	/** plain name of the operation */

	public String name();

	/* mangled name in case of attributes (_get_, _set_) */

	public String opName();

	public String signature();

	public void printSignature(PrintWriter ps);

	/**
	 * @param printModifiers
	 *            whether "public abstract" should be added
	 */
	public void printSignature(PrintWriter ps, boolean printModifiers);

	/** method code for stubs */

	public void printMethod(PrintWriter ps, String classname, boolean is_local);

	/** method code for skeletons */

	public void printDelegatedMethod(PrintWriter ps);

	public void printInvocation(PrintWriter ps);

}
