/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class OrExpr extends IdlSymbol {

	public OrExpr or_expr = null;
	public XorExpr xor_expr;

	public OrExpr(int num) {
		super(num);
	}

	public void setDeclaration(ConstDecl declared_in) {
		xor_expr.setDeclaration(declared_in);
	}

	public void print(PrintWriter ps) {
		if (or_expr != null) {
			or_expr.print(ps);
			ps.print(" | ");
		}
		xor_expr.print(ps);
		ps.flush();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		if (or_expr != null) {
			or_expr.setPackage(s);
		}
		xor_expr.setPackage(s);
	}

	public void parse() {
		if (or_expr != null) {
			or_expr.parse();
		}
		xor_expr.parse();
	}

	int pos_int_const() {
		return xor_expr.pos_int_const();
	}

	public String value() {
		String x = "";
		if (or_expr != null) {
			x = or_expr.value() + " | ";
		}
		return x + xor_expr.value();
	}

	public String toString() {
		String x = "";
		if (or_expr != null) {
			x = or_expr + " | ";
		}
		return x + xor_expr;
	}

	public str_token get_token() {
		return xor_expr.get_token();
	}

}
