/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class PrimaryExpr extends IdlSymbol {

	public IdlSymbol symbol;

	private boolean contained = false;
	private ConstDecl declared_in;

	public PrimaryExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		if (symbol instanceof ConstExpr) {
			ps.print("(");
			symbol.print(ps);
			ps.print(")");
		} else if (symbol instanceof ScopedName) {
			ps.print(((ScopedName) symbol).resolvedName());
			// ps.print( ConstDecl.namedValue( (ScopedName)symbol));
		} else
			// Literal
			symbol.print(ps);
	}

	public void parse() {
		symbol.parse();
	}

	public void setDeclaration(ConstDecl declared_in) {
		this.declared_in = declared_in;
		if (symbol instanceof Literal)
			((Literal) symbol).setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;

		symbol.setPackage(s);
	}

	int pos_int_const() {
		if (symbol instanceof ConstExpr) {
			return ((ConstExpr) symbol).pos_int_const();
		} else if (symbol instanceof ScopedName) {
			return Integer.parseInt(ConstDecl.namedValue((ScopedName) symbol));
		} else
			return Integer.parseInt(((Literal) symbol).toString());
	}

	public String value() {
		if (symbol instanceof ConstExpr) {
			return "(" + ((ConstExpr) symbol).value() + ")";
		} else if (symbol instanceof ScopedName) {
			return ConstDecl.namedValue((ScopedName) symbol);
		} else
			return ((Literal) symbol).toString();
	}

	public String toString() {
		if (symbol instanceof ConstExpr) {
			return "(" + ((ConstExpr) symbol).toString() + ")";
		} else if (symbol instanceof ScopedName) {
			return ((ScopedName) symbol).resolvedName();
		} else {
			return ((Literal) symbol).toString();
		}
	}

	public str_token get_token() {
		return symbol.get_token();
	}
}
