/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class SimpleDeclarator extends Declarator {

	public SimpleDeclarator(int num) {
		super(num);
	}

	public String name() {
		return name;
	}

	/**
	 * @overrides escapeName from Declarator
	 */

	public void escapeName() {
		if (!name.startsWith("_") && lexer.strictJavaEscapeCheck(name)) {
			name = "_" + name;
		}
	}

	public void parse() {
		try {
			NameTable.define(full_name(), "declarator");
		} catch (NameAlreadyDefined p) {
			parser.error("Declarator name " + full_name()
					+ " already declared in this scope.", token);
		}
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
	}

	public IdlSymbol getEnclosingSymbol() {
		return enclosing_symbol;
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
	}

	String full_name() {
		if (name.length() == 0)
			return null;
		if (pack_name.length() > 0)
			return pack_name + "." + name;
		else
			return name;
	}

	public String toString() {
		return name;
	}
}
