/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

class SymbolList extends IdlSymbol {
	Vector v;

	public SymbolList(int num) {
		super(num);
		v = new Vector();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		Enumeration e = v.elements();
		for (; e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).setPackage(s);
	}

	public int size() {
		return v.size();
	}

	public void parse() {
		Enumeration e = v.elements();
		for (; e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).parse();
	}

	public void print(PrintWriter ps) {
		Enumeration e = v.elements();
		if (e.hasMoreElements())
			((IdlSymbol) e.nextElement()).print(ps);

		for (; e.hasMoreElements();) {
			ps.print(",");
			((IdlSymbol) e.nextElement()).print(ps);
		}
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		Enumeration e = v.elements();

		if (e.hasMoreElements())
			sb.append((IdlSymbol) e.nextElement());

		for (; e.hasMoreElements();) {
			sb.append("," + (IdlSymbol) e.nextElement());
		}
		return sb.toString();
	}
}
