/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

public class TypeCodeTypeSpec extends TypeSpec {

	public TypeCodeTypeSpec(int num) {
		super(num);
	}

	public Object clone() {
		return this;
	}

	public String typeName() {
		return "org.omg.CORBA.TypeCode";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
	}

	public boolean basic() {
		return true;
	}

	public void set_constr(TypeDeclaration td) {
	}

	public void parse() {
	}

	public String toString() {
		return typeName();
	}

	/**
	 * @return a string for an expression of type TypeCode that describes this
	 *         type
	 */

	public String getTypeCodeExpression() {
		return "org.omg.CORBA.ORB.init().get_primitive_tc( org.omg.CORBA.TCKind.tk_TypeCode)";
	}

	public void print(PrintWriter ps) {
	}

	public String holderName() {
		return typeName() + "Holder";
	}

	public String printReadExpression(String streamname) {
		return streamname + ".read_TypeCode()";
	}

	public String printWriteStatement(String var_name, String streamname) {
		return streamname + ".write_TypeCode(" + var_name + ");";
	}

}
