/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;

class TypeDeclarator extends IdlSymbol {

	public TypeSpec type_spec;
	public SymbolList declarators;

	public TypeDeclarator(int num) {
		super(num);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		type_spec.setPackage(s);
		for (Enumeration e = declarators.v.elements(); e.hasMoreElements();) {
			Declarator d = (Declarator) e.nextElement();
			d.setPackage(s);
		}
	}

	public void parse() {
		throw new RuntimeException("This method may not be used!");
		/*
		 * declarators.parse(); type_spec.parse();
		 */
	}

	public TypeSpec type_spec() {
		return type_spec.typeSpec();
	}

	public String typeName() {
		return type_spec.typeName();
	}

	public void print(PrintWriter ps) {
		type_spec.print(ps);
		for (Enumeration e = declarators.v.elements(); e.hasMoreElements();)
			((Declarator) e.nextElement()).print(ps);
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		enclosing_symbol = s;
		type_spec.setEnclosingSymbol(s);
		for (Enumeration e = declarators.v.elements(); e.hasMoreElements();)
			((Declarator) e.nextElement()).setEnclosingSymbol(s);
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(type_spec.toString());
		for (Enumeration e = declarators.v.elements(); e.hasMoreElements();)
			sb.append((Declarator) e.nextElement());
		return sb.toString();
	}

}
