/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.util.Enumeration;

/**
 * @author Gerald Brose
 * @version $Id: ValueBody.java,v 1.2 2003/06/08 14:00:45 mep7591 Exp $
 */

class ValueBody extends InterfaceBody {

	public ValueAbsDecl myAbsValue;

	ValueBody(int num) {
		super(num);
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;

		for (Enumeration e = v.elements(); e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).setEnclosingSymbol(myAbsValue);
	}

}
