/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class XorExpr extends IdlSymbol {

	public XorExpr xor_expr = null;
	public AndExpr and_expr;

	public XorExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		if (xor_expr != null) {
			xor_expr.print(ps);
			ps.print(" ^ ");
		}
		and_expr.print(ps);
	}

	public void setDeclaration(ConstDecl declared_in) {
		and_expr.setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		if (xor_expr != null) {
			xor_expr.setPackage(s);
		}
		and_expr.setPackage(s);
	}

	public void parse() {
		if (xor_expr != null) {
			xor_expr.parse();
		}
		and_expr.parse();
	}

	int pos_int_const() {
		return and_expr.pos_int_const();
	}

	public String value() {
		String x = "";
		if (xor_expr != null) {
			x = xor_expr.value() + "^";
		}
		return x + and_expr.value();
	}

	public String toString() {
		String x = "";
		if (xor_expr != null) {
			x = xor_expr + "^";
		}
		return x + and_expr;
	}

	public str_token get_token() {
		return and_expr.get_token();
	}
}
