/* Orbas Naming Server:
 *     A open source CORBA CosNaming implementation from Huihoo.
 *
 * Copyright 2003 Huihoo Power, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.naming;

/**
 * <p>Description: </p>
 * BindingIterator Implemention.
 * <p>Copyright (c) 2003</p>
 * <p>Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorPOA;
import org.omg.CosNaming.BindingListHolder;

public class BindingIteratorImpl extends BindingIteratorPOA {
	/**
	 * Private Section.
	 */
	private Iterator binding;
	private int size = 0;

	/**
	 * roseuid 3E8A61AB0232
	 */
	public BindingIteratorImpl(Binding[] b) {
		Collection c = new ArrayList();
		//
		for (int i = 0; i < b.length; i++) {
			c.add(b[i]);
		}
		//
		binding = c.iterator();
		size = c.size();
	}

	/**
	 * roseuid 3E8A61AB0242
	 */
	public void destroy() {
		binding = null;
		try {
			finalize();
		} catch (Throwable t) {
		}

	}

	/**
	 * @param b
	 * @return boolean roseuid 3E8A61AB0251
	 */
	public boolean next_one(BindingHolder b) {
		boolean retValue = false;
		if (binding.hasNext()) {
			Binding _bind = (Binding) binding.next();
			b.value = _bind;
			retValue = true;
		} else {
			b.value = new Binding(new org.omg.CosNaming.NameComponent[0],
					org.omg.CosNaming.BindingType.nobject);
			retValue = false;
		}
		//
		return retValue;

	}

	/**
	 * @param how_many
	 * @param bl
	 * @return boolean roseuid 3E8A61AB0271
	 */
	public boolean next_n(int how_many, BindingListHolder bl) {
		if (how_many == 0) {
			throw new org.omg.CORBA.BAD_PARAM();
		}
		//
		boolean retValue = false;
		//
		ArrayList _binds = new ArrayList();
		if (binding.hasNext()) {
			while (binding.hasNext()) {
				_binds.add((Binding) binding.next());
			}
			//
			bl.value = (Binding[]) _binds.toArray(new Binding[0]);

		} else {
			bl.value = new Binding[0];
			retValue = false;

		}

		//
		return retValue;
	}

}
