/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.ior;

/**
 * <p>Description: </p>
 * Byted IOR parser.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.ORB;
import org.omg.IOP.TaggedProfile;

public class BytedIor {
	private ORB orb;
	private TaggedProfile[] profiles;
	private String typeID;
	private String s;
	private byte[] ior;
	private org.omg.CORBA.Object obj;

	public BytedIor(ORB orb, byte[] ior) {
		this.orb = orb;
		this.ior = ior;
	}

	public String getTypeId() {
		return this.typeID;
	}

	public TaggedProfile[] getProfiles() {
		return this.profiles;
	}

	public org.omg.CORBA.Object getObject() {
		return this.obj;
	}

	public byte[] getBytes() {
		return this.ior;
	}

	public String toString() {
		return this.s;
	}

	public boolean isA(String ID) {
		return ID.equals(typeID);
	}
}
