/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

/* Generated by Together */

package org.huihoo.orbas.orb.ior;

/**
 * <p>Description: </p>
 * CORBAloc ior parser.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.omg.IOP.IOR;

public class CorbaLocParser {
	String uri;

	public CorbaLocParser(String uri) {
		this.uri = uri;
	}

	public void parse() {
		if (uri == null) {
			return;
		}

		String host;
		short port;
		String objectKey;
		int version;

		java.util.StringTokenizer tokens = new java.util.StringTokenizer(uri,
				":");

		String loc = tokens.nextToken();

		if (loc.equalsIgnoreCase("corbaloc")) {
			// corbaloc schema
			String prot = tokens.nextToken();

			if (prot.equalsIgnoreCase("iiop") || prot.equalsIgnoreCase("")) {

				// iiop protocols,next token is iiop
				// version and host address
				String objAddr = tokens.nextToken();
				int addrIndex = objAddr.indexOf('@');

				if (addrIndex != -1) {
					// iiop version here,if index is not -1
					// it must be 3

					String stringMajorVersion = objAddr.substring(0, 1);
					String stringMinorVersion = objAddr.substring(1, 2);

					try {
						version = Integer.valueOf(stringMajorVersion)
								.intValue();
						version *= 10;
						version += Integer.valueOf(stringMinorVersion)
								.intValue();
					} catch (NumberFormatException ex) {
						// bad url
					}

					// multiple host allowed.do NOT support now.
					host = objAddr.substring(addrIndex + 1,
							objAddr.length() - 1);
				} else {
					// then all right,default iiop version assumed.
					// multiple host allowed.do NOT support now.
					host = objAddr;
				}

				// resolve port number next
				String remain = tokens.nextToken();
				if (remain.startsWith("/")) {
					// port number is here
					int portIndex = remain.indexOf("/");
					if (portIndex != -1) {
						String portString = remain.substring(0, portIndex - 1);
						objectKey = remain.substring(portIndex + 1,
								remain.length() - 1);

						try {
							port = (short) Integer.valueOf(portString)
									.intValue();
						} catch (NumberFormatException ex) {
							// bad url
						}
					} else {
						// bad url
					}
				} else {
					// no port number,default port assumed
					// which is default port?
					port = 683;
					objectKey = remain;
				}

			} else if (prot.equalsIgnoreCase("rir")) {
				// Resolve initial references protocols

			} else if (prot.equalsIgnoreCase("atm")) {
				// atm protocols, check configuration if
				// orbas or its pluggin support it.

			} else if (prot.equalsIgnoreCase("dce")) {
				// atm protocols, check configuration if
				// orbas or its pluggin support it.

			}

		} else if (loc.equalsIgnoreCase("iioploc")) {
			// old iioploc schema

		}

	}

	public IOR getIor() {
		return null;
	}
}
