/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.protocols;

/**
 * <p>Description: </p>
 * Listener for a protocols.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.ORB;
import org.huihoo.orbas.orb.thread.RequestQueue;

public class Listener implements java.lang.Runnable {

	ORB orb;
	boolean flag;
	RequestQueue queue;

	public Listener(ORB orb) {
		this.orb = orb;
		flag = true;
		queue = orb.getRequestQueue();
	}

	public void run() {
		Channel ch = orb.getProfileRegistry()
				.getProfileCreator(orb.getDefautTransportProtocol())
				.createChannel();

		while (flag) {
			Transport t = ch.accept();

			if (t == null) {
				System.out.println("Listener:Got null transport");
				continue;
			}

			queue.add2Queue(t);
		}
	}

	public void shutdown() {
		flag = false;
	}
}