/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.protocols;

/**
 * <p>Description: </p>
 * A pool for all transports.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.ORB;

public class TransportsPool {

	private java.util.Hashtable allTransports;
	ORB orb;

	public TransportsPool(ORB orb) {
		allTransports = new java.util.Hashtable();
		this.orb = orb;
	}

	public void setStrategy(int stra) {

	}

	public Transport getTransport(TargetAddress a) {
		Transport t = (Transport) (allTransports.get(a.toString()));

		if (t == null) {
			Channel ch = a.initialChannel();

			System.out.println("A new connection established");
			t = ch.setup();

			putTransport(t);
		}

		return t;
	}

	public void putTransport(Transport t) {
		allTransports.put(t.getTargetAddress(), t.toString());
	}

	public void removeTransport(Transport t) {
		allTransports.remove(t.getTargetAddress());
	}

}