/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.protocols.iiop;

/**
 * <p>Description: </p>
 * IIOP profiles extractor.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

//import org.omg.IOP.*;
//import org.omg.IIOP.*;
import org.huihoo.orbas.orb.cdr.CDRInputStream;
import org.huihoo.orbas.orb.protocols.ProfileExtractor;
import org.huihoo.orbas.orb.protocols.TargetAddress;

public class IiopProfileExtractor extends ProfileExtractor {

	TargetAddress target;
	byte[] objectKey;
	int version;
	org.omg.IOP.TaggedComponent[] taggedComponents;

	public IiopProfileExtractor(CDRInputStream in) {
		super(in);
	}

	public IiopProfileExtractor() {

	}

	public TargetAddress getTargetAddress() {
		return target;
	}

	public org.omg.IOP.TaggedComponent[] getTaggedComponents() {
		return taggedComponents;
	}

	public void parse() {

		in.mark();

		org.omg.IIOP.ProfileBody_1_0 profileBody = org.omg.IIOP.ProfileBody_1_0Helper
				.read(in);

		switch (profileBody.iiop_version.major) {
		case 1:

			switch (profileBody.iiop_version.minor) {

			case 0:
				target = new IiopTargetAddress(profileBody.host,
						profileBody.port);
				objectKey = profileBody.object_key;
				version = 10;
				break;

			case 1:
				version = 11;
			case 2:

				// in.reset();
				// ProfileBody_1_1 profileBody_1_1 =
				// ProfileBody_1_1Helper.read(in);
				//
				// target = new
				// IiopTargetAddress(profileBody_1_1.host,profileBody_1_1.port);
				// objectKey = profileBody_1_1.object_key;
				// taggedComponents = profileBody_1_1.components;

				target = new IiopTargetAddress(profileBody.host,
						profileBody.port);
				objectKey = profileBody.object_key;
				if (version != 11) {
					version = 12;
				}
				break;

			default:
				// error
			}
			break;
		default:
			// error
		}
	}

	public byte[] getObjectKey() {
		return objectKey;
	}

	public int getVersion() {
		return version;
	}

}