/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.protocols.iiop;

/**
 * <p>Description: </p>
 * IIOP protocols initializer.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.ORB;
import org.huihoo.orbas.orb.protocols.ProfileRegistry;
import org.huihoo.orbas.orb.protocols.ProtocolInitializer;

public class IiopProtocolInitializer extends ProtocolInitializer {

	public static void setup(ORB orb) {

		ProfileRegistry profileDealers = orb.getProfileRegistry();
		profileDealers.registerProfileDealer(
				org.omg.IOP.TAG_INTERNET_IOP.value, new IiopProfileCreator(),
				new IiopProfileExtractor());

		orb.registerServerBroadcaster(org.omg.IOP.TAG_INTERNET_IOP.value,
				new IiopBroadcaster(orb));
	}

}