/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.protocols.iiop;

/**
 * <p>Description: </p>
 * TCP/IP imlementation for target address.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.protocols.Channel;
import org.huihoo.orbas.orb.protocols.TargetAddress;

public class IiopTargetAddress extends TargetAddress {

	private String host;
	private short port;

	public IiopTargetAddress(String host, short port) {
		this.host = host;
		this.port = port;
	}

	public int getProtocolTag() {
		return org.omg.IOP.TAG_INTERNET_IOP.value;
	}

	public boolean equals(Object other) {
		IiopTargetAddress a1 = (IiopTargetAddress) other;

		if (a1 == null) {
			return false;
		}

		if (host.equals(a1.getHost()) && (a1.getPort() == port)) {
			return true;
		}

		return false;
	}

	public String toString() {

		Integer i = new Integer(port);
		String part = i.toString();
		return host + part;
	}

	public String getHost() {
		return host;
	}

	public short getPort() {
		return port;
	}

	public Channel initialChannel() {
		IiopChannel ch = new IiopChannel();
		ch.setTargetAddress(this);
		return ch;
	}

}