/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.thread;

/**
 * <p>Description: </p>
 * A queue for incoming request.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.ORB;
import org.huihoo.orbas.orb.protocols.Transport;

public class RequestQueue {

	java.util.LinkedList queue;
	ORB orb;

	public RequestQueue(ORB orb) {
		this.orb = orb;
		queue = new java.util.LinkedList();
	}

	public synchronized void add2Queue(Transport t) {
		queue.addFirst(t);
		try {
			notifyAll();
		} catch (java.lang.IllegalMonitorStateException e) {
			System.out.println("Request Queue Error.");
		}
	}

	public synchronized Transport removeFromQueue() {

		Transport t = null;
		while (true) {
			try {
				t = (Transport) queue.removeLast();
				return t;
			} catch (java.util.NoSuchElementException e) {
				try {
					wait();
				} catch (java.lang.InterruptedException ex) {
					continue;
				}
			}
		}
	}
}