/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.typecode;

/**
 * <p>
 * Description:
 * </p>
 * TypeCode for abstract interface.
 * <p>
 * Copyright (c) 2002,2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

public class TypeCodeAbstractInterface extends TypeCodeBase {

	String id;
	String name;

	public TypeCodeAbstractInterface(String id, String name) {
		this.id = id;
		this.name = name;
	}

	public boolean equal(org.omg.CORBA.TypeCode tc) {
		if (tc.kind() != org.omg.CORBA.TCKind.tk_abstract_interface) {
			return false;
		}

		if (this == tc) {
			return true;
		}

		try {
			if ((this.id == tc.id()) && (this.name == tc.name())) {
				return true;
			} else {
				return false;
			}
		} catch (org.omg.CORBA.TypeCodePackage.BadKind ex) {
			return false;
		}

	}

	public org.omg.CORBA.TypeCode get_compact_typecode() {
		return new TypeCodeAbstractInterface(id, null);
	}

	public org.omg.CORBA.TCKind kind() {
		return org.omg.CORBA.TCKind.tk_abstract_interface;
	}

	public java.lang.String id() throws org.omg.CORBA.TypeCodePackage.BadKind {
		return id;
	}

	public java.lang.String name() throws org.omg.CORBA.TypeCodePackage.BadKind {
		return name;
	}

	public int member_count() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public java.lang.String member_name(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode member_type(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.Any member_label(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode discriminator_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int default_index() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int length() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode content_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short fixed_digits() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short fixed_scale() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short member_visibility(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short type_modifier() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode concrete_base_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}
}
