/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.poa;

/**
 * <p>
 * Description:
 * </p>
 * Object key represent.
 * <p>
 * Copyright (c) 2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

public class ObjectKey {
	private String poaId;
	private String objectId;

	public ObjectKey(byte[] poaId, byte[] oid) {
		this.poaId = new String(poaId);
		this.objectId = new String(oid);
	}

	public ObjectKey(String objectKey) {
		int index = objectKey.indexOf('/');

		if (index == -1) {
			throw new org.omg.CORBA.OBJECT_NOT_EXIST(
					"POA: Malformed object key");
		}
		poaId = objectKey.substring(0, index);
		objectId = objectKey.substring(index + 1, objectKey.length() - index
				- 1);

	}

	public int hashCode() {
		// return System.identityHashCode(target);
		return (poaId + objectId).hashCode();
	}

	public boolean equals(Object obj) {
		if ((obj instanceof ObjectKey)) {
			if (((ObjectKey) obj).getPOAId().equals(getPOAId())
					&& ((ObjectKey) obj).getObjectId().equals(getObjectId())) {
				return true;
			}
		}
		return false;
	}

	public byte[] getPOAId() {
		return poaId.getBytes();
	}

	public byte[] getObjectId() {
		return objectId.getBytes();
	}

	public String getObjectKey() {
		return (new String(getPOAId())) + "/" + (new String(getObjectId()));
	}

	public String toString() {
		return getObjectKey();
	}

}