/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.rtutil.threadpool;

/**
 * <p>
 * Description: PriorityNode
 * </p>
 * <p>
 * Copyright (c) 2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

class PriorityNode implements Comparable {
	private int priority = 0;
	private Object value;

	public PriorityNode(int priority, Object value) {
		this.priority = priority;
		this.value = value;
	}

	public int compareTo(Object o) {
		// Check the argument first.
		if (!(o instanceof PriorityNode)) {
			throw new IllegalArgumentException(
					"Argument variable must be PriorityNode instance.");
		}
		// compare.
		int ret = priority - ((PriorityNode) o).getPriority();
		// return value.
		return ret;
	}

	public int getPriority() {
		return this.priority;
	}

	public Object getValue() {
		return this.value;
	}

	public boolean equals(Object o) {
		// Check the argument first.
		if (!(o instanceof PriorityNode)) {
			throw new IllegalArgumentException(
					"Argument variable must be PriorityNode instance.");
		}

		Object _other = ((PriorityNode) o).getValue();
		return value.equals(o);
	}

}
