/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.rtutil.threadpool.test;

/**
 * <p>Description: Test case for PriorityChannel</p>
 * <p>Copyright (c) 2003</p>
 * <p>Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.rtutil.threadpool.PriorityChannel;

class PriorityChannelTest {
	public PriorityChannelTest() {
	}

	public static void main(String[] args) throws Exception {
		final PriorityChannelTest testCase = new PriorityChannelTest();
		//
		Thread testThread = new Thread() {
			public void run() {
				try {
					testCase.test();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		};
		//
		testThread.start();
		try {
			testThread.join();
		} catch (InterruptedException e) {
		}
		System.exit(0);
	}

	public void test() throws Exception {
		System.out.println("==PriorityChannel Test Begin.==");
		// create the new channel with size maxSize.
		int maxSize = 5;
		final PriorityChannel channel = new PriorityChannel(maxSize);
		// =================================
		// Test the poll method.
		// Now the channel is empty,and the poll method will return null after
		// the time.
		System.out.println("==poll() method test begin==");
		System.out.println("Channel size=" + channel.getCurrentSize());
		long waittime = 3000;
		long curtime = System.currentTimeMillis();
		Object pollret = channel.poll(waittime);
		System.out.println("Wait Time:" + waittime + ",Actual Time:"
				+ (System.currentTimeMillis() - curtime)
				+ ",Return will be null,Actual is " + pollret);
		if (pollret != null) {
			System.out.println("Test failed!");
		} else {
			System.out.println("Test success!");
		}
		System.out.println("==poll() method test end==");
		// end of Test the poll method.
		// =================================
		// =================================
		// Test the take method.
		// Now the channel is empty,and the take method will be hold until
		// channel not empty.
		System.out.println("==take() method test begin==");
		System.out.println("Channel size=" + channel.getCurrentSize());
		Thread takeThread = new Thread() {
			public void run() {
				try {
					System.out.println("take() method be hold here...");
					Object o = channel.take();
					System.out.println("take() method be hold release,return:"
							+ o.toString());

				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		};
		takeThread.start();
		System.out.println("Main thread sleep 3 seconds to hold take() 3 s.");
		Thread.sleep(3000);
		System.out
				.println("put a item to channel will release the take() method.");
		channel.put("a element.");
		try {
			takeThread.join();
		} catch (InterruptedException e) {
		}
		System.out.println("==take() method test end==");
		//
		// end of Test the take method.
		// =================================
		// =================================
		// Test the offer() method.
		System.out.println("==offer() method test begin==");
		System.out.println("Channel size=" + channel.getCurrentSize());
		// make the channel full.
		System.out.println("Fill the channel to full.");
		for (int i = 0; i < maxSize; i++) {
			channel.put(String.valueOf(i));
			System.out.println("Fill a element:" + i);
		}
		System.out
				.println("offer() method will return false after wait time 3 seconds.");
		Thread offerThread = new Thread() {
			public void run() {
				long offercurtime = System.currentTimeMillis();

				try {
					boolean offerret = channel.offer("myelement", 3000);

					System.out.println("Wait Time:" + 3000 + ",Actual Time:"
							+ (System.currentTimeMillis() - offercurtime)
							+ ",Return will be false,Actual is " + offerret);
					if (offerret) {
						System.out.println("Test failed!");
					} else {
						System.out.println("Test success!");
					}
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

			}
		};
		offerThread.start();
		//
		// System.out.println("take a element from channel to rel");
		System.out.println("==offer() method test end==");
		// end of Test the offer method.
		// =================================
		// =================================
		// Test the put() method.
		System.out.println("==put() method test begin==");
		System.out.println("Channel size=" + channel.getCurrentSize());
		// now the channel is full.
		Thread putThread = new Thread() {
			public void run() {
				System.out.println("put() method be hold here...");
				try {
					channel.put("my put element.");
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				System.out.println("put() method be hold release");

			}
		};
		putThread.start();
		System.out.println("Main thread sleep 3 seconds to hold put() 3 s.");
		Thread.sleep(3000);
		System.out
				.println("take a item to channel will release the put() method.");
		Object putO = channel.take();
		System.out.println("Get the Put element return:" + putO.toString());
		System.out.println("==put() method test end==");
		// end of Test the put method.
		// =================================
		System.out.println("Channel size=" + channel.getCurrentSize());
		System.out.println("==PriorityChannel Test End.==");
		// exit.
		// System.exit(0);
	}

}
