/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.rtutil.threadpool.test;

/**
 * <p>Description: Test case for RTThreadPool</p>
 * <p>Copyright (c) 2003</p>
 * <p>Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.rtutil.threadpool.RTThreadPool;

public class RTPoolTest {
	public RTPoolTest() {
	}

	public static void main(String[] args) throws Exception {
		final RTPoolTest testCase = new RTPoolTest();
		Thread testThread = new Thread() {
			public void run() {
				try {
					testCase.testAll();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		};
		//
		testThread.start();
		//
		try {
			testThread.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		// exit.
		System.exit(0);
	}

	public void testAll() throws Exception {
		Runnable logic = new Runnable() {
			public void run() {
				System.out.println("Has run in the execution logic.");
			}
		};
		//
		System.out.println("<<Pool without lanes Test Begin");
		//
		System.out.println("Creating the pool...");
		//
		RTThreadPool pool = new RTThreadPool(2, 12);
		//
		System.out.println("Creating the pool:Complete.");
		//
		System.out.println("Execute the 5 execution logic.");
		//
		pool.execute(logic);
		pool.execute(logic);
		pool.execute(logic);
		pool.execute(logic);
		pool.execute(logic);
		//
		System.out.println("Execute the 5 execution logic:Complete.");
		//
		System.out.println(">>Pool without lanes Test End");
	}

}