package com.mobit.models;

import java.util.ArrayList;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.mobit.takeout.R;
import com.mobit.takeout.R.id;
import com.mobit.takeout.R.layout;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;

public class MenuAdapter extends BaseAdapter {
	private ArrayList<Menu> menuList;
	private LayoutInflater inflater;
	private DisplayImageOptions options;

	public MenuAdapter(Context context, ArrayList<Menu> menuList) {
		this.menuList = menuList;
		this.inflater = LayoutInflater.from(context);
		options = new DisplayImageOptions.Builder()
				.showImageForEmptyUri(R.drawable.java_old_school)
				.showImageOnFail(R.drawable.java_old_school).build();

	}

	@Override
	public int getCount() {
		return menuList.size();
	}

	@Override
	public Object getItem(int position) {
		return menuList.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		ItemHolder holder;

		if (convertView == null) {
			convertView = inflater.inflate(R.layout.menu_list_item, null);
			holder = new ItemHolder();

			holder.food_tite = (TextView) convertView
					.findViewById(R.id.txtv_title);
			holder.price = (TextView) convertView.findViewById(R.id.txtv_price);
			holder.ingredients = (TextView) convertView
					.findViewById(R.id.txtv_ingredients);

			holder.logo = (ImageView) convertView
					.findViewById(R.id.img_food_logo);

			convertView.setTag(holder);

		} else {
			holder = (ItemHolder) convertView.getTag();
		}

		Menu menu = menuList.get(position);
		holder.food_tite.setText(menu.getFood_title());
		holder.ingredients.setText(menu.getIngredients());

		holder.price.setText(menu.getPrice());

		if (holder.logo != null) {
			ImageLoader.getInstance().displayImage(menu.getLogo(), holder.logo,
					options);

		}
		return convertView;
	}

	private static class ItemHolder {
		TextView food_tite;
		TextView ingredients;
		TextView price;
		ImageView logo;

	}
}
